ALTER TABLE `smartend_topics`
    ADD `featured` TINYINT NOT NULL DEFAULT '0' AFTER `status`;
ALTER TABLE `smartend_webmaster_sections`
    ADD `featured_status` TINYINT NOT NULL DEFAULT '0' AFTER `case_status`;
ALTER TABLE `smartend_webmaster_sections`
    ADD `code_status` TINYINT NOT NULL DEFAULT '0' AFTER `seo_status`;

ALTER TABLE `smartend_topics`
    ADD `css_code`  LONGTEXT NULL AFTER `topic_id`,
    ADD `js_code`   LONGTEXT NULL AFTER `css_code`,
    ADD `body_code` LONGTEXT NULL AFTER `js_code`;
ALTER TABLE `smartend_sections`
    ADD `css_code`  LONGTEXT NULL AFTER `popup_id`,
    ADD `js_code`   LONGTEXT NULL AFTER `css_code`,
    ADD `body_code` LONGTEXT NULL AFTER `js_code`;
ALTER TABLE `smartend_webmaster_sections`
    ADD `css_code`  LONGTEXT NULL AFTER `popup_id`,
    ADD `js_code`   LONGTEXT NULL AFTER `css_code`,
    ADD `body_code` LONGTEXT NULL AFTER `js_code`;

ALTER TABLE `smartend_webmaster_settings`
    ADD `slug_translation` TINYINT NOT NULL DEFAULT '1' AFTER `image_resize_height`;

ALTER TABLE `smartend_webmaster_settings`
    ADD `instant_index`           TINYINT      NOT NULL DEFAULT '0' AFTER `slug_translation`,
    ADD `instant_index_file`      VARCHAR(191) NULL AFTER `instant_index`,
    ADD `instant_index_on_create` TINYINT      NOT NULL DEFAULT '0' AFTER `instant_index_file`,
    ADD `instant_index_on_update` TINYINT      NOT NULL DEFAULT '0' AFTER `instant_index_on_create`,
    ADD `instant_index_on_delete` TINYINT      NOT NULL DEFAULT '0' AFTER `instant_index_on_update`;

ALTER TABLE `smartend_webmaster_sections`
    ADD `index_status` TINYINT NOT NULL DEFAULT '1' AFTER `featured_status`;

UPDATE `smartend_sections`
SET `icon` = CONCAT('fa ', `icon`)
WHERE `icon` IS NOT NULL
  AND `icon` != ''
  AND `icon` NOT LIKE 'fa %';
UPDATE `smartend_menus`
SET `icon` = CONCAT('fa ', `icon`)
WHERE `icon` IS NOT NULL
  AND `icon` != ''
  AND `icon` NOT LIKE 'fa %';
UPDATE `smartend_banners`
SET `icon` = CONCAT('fa ', `icon`)
WHERE `icon` IS NOT NULL
  AND `icon` != ''
  AND `icon` NOT LIKE 'fa %';
UPDATE `smartend_topics`
SET `icon` = CONCAT('fa ', `icon`)
WHERE `icon` IS NOT NULL
  AND `icon` != ''
  AND `icon` NOT LIKE 'fa %';

ALTER TABLE `smartend_settings`
    CHANGE `social_link10` `whatsapp_no` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL;

ALTER TABLE `smartend_settings`
    ADD COLUMN `social_links` JSON DEFAULT NULL AFTER `social_link9`;

ALTER TABLE `smartend_webmaster_section_fields`
    ADD `categories` VARCHAR(255) NULL AFTER `lang_code`;


ALTER TABLE `smartend_topics`
    ADD `hide_header` BOOLEAN NOT NULL DEFAULT FALSE AFTER `body_code`,
    ADD `hide_footer` BOOLEAN NOT NULL DEFAULT FALSE AFTER `hide_header`;

ALTER TABLE `smartend_webmaster_settings`
    ADD `homepage_type`   TINYINT NOT NULL DEFAULT '0' AFTER `home_contents_per_page`,
    ADD `landing_page_id` INT     NULL AFTER `homepage_type`;



CREATE TABLE `smartend_topic_blocks`
(
    `id`              bigint UNSIGNED NOT NULL,
    `row_no`          int             NOT NULL                DEFAULT '0',
    `topic_id`        bigint UNSIGNED NOT NULL,
    `block_name`      varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `type`            tinyint         NOT NULL                DEFAULT '0',
    `content`         longtext COLLATE utf8mb4_unicode_ci,
    `title_status`    tinyint         NOT NULL                DEFAULT '0',
    `desc_status`     tinyint         NOT NULL                DEFAULT '0',
    `image_status`    tinyint         NOT NULL                DEFAULT '0',
    `divider_status`  tinyint         NOT NULL                DEFAULT '0',
    `more_btn_status` tinyint         NOT NULL                DEFAULT '0',
    `bg_color`        varchar(30) COLLATE utf8mb4_unicode_ci  DEFAULT NULL,
    `css_classes`     varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `status`          tinyint         NOT NULL                DEFAULT '0',
    `created_by`      int                                     DEFAULT NULL,
    `updated_by`      int                                     DEFAULT NULL,
    `created_at`      timestamp       NULL                    DEFAULT NULL,
    `updated_at`      timestamp       NULL                    DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;


ALTER TABLE `smartend_topic_blocks`
    ADD PRIMARY KEY (`id`),
    ADD KEY `page_blocks_topic_id` (`topic_id`);

ALTER TABLE `smartend_topic_blocks`
    MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

ALTER TABLE `smartend_topic_blocks`
    ADD CONSTRAINT `page_blocks_topic_id` FOREIGN KEY (`topic_id`) REFERENCES `smartend_topics` (`id`);



UPDATE `smartend_settings`
SET `social_links` = JSON_ARRAY(
        CASE
            WHEN `social_link1` IS NOT NULL AND `social_link1` != '' THEN
                JSON_OBJECT('row_id', '1', 'row_no', '1', 'title', 'Facebook', 'url', `social_link1`, 'icon',
                            'fab fa-facebook', 'color', '#1877f2')
            ELSE NULL END,
        CASE
            WHEN `social_link2` IS NOT NULL AND `social_link2` != '' THEN
                JSON_OBJECT('row_id', '2', 'row_no', '2', 'title', 'X', 'url', `social_link2`, 'icon', 'fas fa-times',
                            'color', '#000000')
            ELSE NULL END,
        CASE
            WHEN `social_link4` IS NOT NULL AND `social_link4` != '' THEN
                JSON_OBJECT('row_id', '3', 'row_no', '3', 'title', 'LinkedIn', 'url', `social_link4`, 'icon',
                            'fab fa-linkedin', 'color', '#0077b5')
            ELSE NULL END,
        CASE
            WHEN `social_link5` IS NOT NULL AND `social_link5` != '' THEN
                JSON_OBJECT('row_id', '4', 'row_no', '4', 'title', 'YouTube', 'url', `social_link5`, 'icon',
                            'fab fa-youtube', 'color', '#ff0000')
            ELSE NULL END,
        CASE
            WHEN `social_link6` IS NOT NULL AND `social_link6` != '' THEN
                JSON_OBJECT('row_no', '5', 'title', 'Instagram', 'url', `social_link6`, 'icon', 'fab fa-instagram',
                            'color', '#e4405f')
            ELSE NULL END,
        CASE
            WHEN `social_link7` IS NOT NULL AND `social_link7` != '' THEN
                JSON_OBJECT('row_id', '6', 'row_no', '6', 'title', 'Pinterest', 'url', `social_link7`, 'icon',
                            'fab fa-pinterest', 'color', '#bd081c')
            ELSE NULL END,
        CASE
            WHEN `social_link8` IS NOT NULL AND `social_link8` != '' THEN
                JSON_OBJECT('row_id', '7', 'row_no', '7', 'title', 'Threads', 'url', `social_link8`, 'icon',
                            'fab fa-facebook', 'color', '#1877f2')
            ELSE NULL END,
        CASE
            WHEN `social_link9` IS NOT NULL AND `social_link9` != '' THEN
                JSON_OBJECT('row_id', '8', 'row_no', '8', 'title', 'Snapchat', 'url', `social_link9`, 'icon',
                            'fab fa-snapchat', 'color', '#c9c70a')
            ELSE NULL END
                     );

ALTER TABLE `smartend_settings`
    DROP `social_link1`,
    DROP `social_link2`,
    DROP `social_link3`,
    DROP `social_link4`,
    DROP `social_link5`,
    DROP `social_link6`,
    DROP `social_link7`,
    DROP `social_link8`,
    DROP `social_link9`;

UPDATE `smartend_webmaster_settings`
SET `version`='12.0.0';
